---
title: Account takeover detections · Cloudflare bot solutions docs
description: Using the detection IDs below, you can detect and mitigate account
  takeover attacks. You can monitor the number of login requests for a given
  software and network combination, as well as the percentage of login errors.
  When it reaches a suspicious level, you can prevent these attacks by using
  custom rules, rate limiting rules, and Workers.
lastUpdated: 2025-11-05T15:19:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/bots/additional-configurations/detection-ids/account-takeover-detections/
  md: https://developers.cloudflare.com/bots/additional-configurations/detection-ids/account-takeover-detections/index.md
---

Using the detection IDs below, you can detect and mitigate account takeover attacks. You can monitor the number of login requests for a given software and network combination, as well as the percentage of login errors. When it reaches a suspicious level, you can prevent these attacks by using [custom rules](https://developers.cloudflare.com/waf/custom-rules/), [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/), and [Workers](https://developers.cloudflare.com/workers/).

| Detection ID | Description |
| - | - |
| `201326592` | Observes all login failures to the zone. |
| `201326593` | Observes all login traffic to the zone. |
| `201326598` | Sets a dynamic threshold based on the normal traffic that is unique to the zone. When the ID matches a login failure, Bot Management sets the [bot score](https://developers.cloudflare.com/bots/concepts/bot-score/) to 29 and uses [anomaly detection](https://developers.cloudflare.com/bots/concepts/bot-detection-engines/#anomaly-detection-enterprise) as its score source. |

## Challenges for account takeover detections

Cloudflare's [Managed Challenge](https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/#managed-challenge-recommended) can limit brute-force attacks on your login endpoints.

To access account takeover detections:

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **WAF**.
  3. Under **Custom rules**, select **Create rule**.
  4. Fill out the form using **Bot Detection IDs** along with other necessary information.
  5. Select **Save as draft** to return to the rule later, or **Deploy** to deploy the rule.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security rules** page.

     [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules)

  2. Select **Create rule** and choose **Custom rule**.

  3. Fill out the form using **Bot Detection IDs** along with other necessary information.

  4. Select **Save as draft** to return to the rule later, or **Deploy** to deploy the rule.

```js
(any(cf.bot_management.detection_ids[*] eq 201326593))
```

## Limit logins with account takeover detections

Rate limiting rules can limit the number of logins from a particular IP, JA4 fingerprint, or country.

To use rate limiting rules with account takeover detections:

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **WAF**.
  3. Under **Rate limiting rules**, select **Create rule**.
  4. Fill out the form using the **Custom expression builder** and `cf.bot_management_detection_ids` along with other necessary information.
  5. Select **Save as draft** to return to the rule later, or **Deploy** to deploy the rule.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security rules** page.

     [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules)

  2. Select **Create rule** and choose **Rate limiting rule**.

  3. Fill out the form using the **Custom expression builder** and `cf.bot_management_detection_ids` along with other necessary information.

  4. Select **Save as draft** to return to the rule later, or **Deploy** to deploy the rule.

Enhanced with leaked credential detections

The rule can be enhanced with Leaked Credential Checks. Refer to the [WAF documentation](https://developers.cloudflare.com/waf/detections/leaked-credentials/) for more information on how to include leaked credentials and account takeover detections in a rate limiting rule.
